<?php
require_once "../functions/sortArrays.php";

function countActiveZones($timezones)
{
   $count = 0;
   foreach ($timezones as $zone) {
      //считаем количество активных зон
      $count += $zone->state;
   }
   return $count;
}

function addStartAndEndZone($server, $arr, $count)
{
   $timezones = $server->server->timezone;
   $timezones = sort_nested_arrays($timezones, ["index" => "desc"]);

   $n = count($timezones);
   if ($n == 2) {
      $timezones[2] = (object) [];
      $timezones[2] = $timezones[1];

      $timezones[3] = (object) [];
      $timezones[3] = $timezones[1];
      $timezones[1]->index = 1;
      $timezones[1]->state = 1;
   } elseif ($n == 3) {
      $timezones[3] = (object) [];
      $timezones[3] = $timezones[1];
   }
   for ($i = 0; $i < $n; $i++) {
      isset($timezones[$i]->start) ? "" : ($timezones[$i]->start = $i);
   }
   switch ($count) {
      case 1:
         $arr[0]["index"] = $timezones[0]->index;
         $arr[1]["index"] = $timezones[1]->index;

         $arr[2]["index"] = $timezones[2]->index;

         $arr[3]["state"] = $timezones[3]->state;

         $arr[3]["start"] = $timezones[0]->start;
         $arr[3]["index"] = $timezones[3]->index;
         $arr[3]["end"] = $timezones[3]->start - 1;

         break;

      case 2:
         $arr[0]["index"] = $timezones[1]->index;
         $arr[1]["index"] = $timezones[1]->index;
         $arr[2]["index"] = $timezones[2]->index;
         $arr[3]["index"] = $timezones[0]->index;

         $arr[0]["state"] = $timezones[0]->state;

         $arr[0]["start"] = $timezones[0]->start;
         $arr[0]["index"] = $timezones[0]->index;
         $arr[0]["end"] = $timezones[3]->start - 1;

         $arr[3]["state"] = $timezones[3]->state;
         $arr[3]["start"] = $timezones[3]->start;
         $arr[3]["index"] = $timezones[3]->index;
         $arr[3]["end"] = $timezones[0]->start - 1;
         break;

      case 3:
         $arr[3]["state"] = $timezones[3]->state;
         $arr[3]["start"] = $timezones[3]->start;
         $arr[3]["index"] = $timezones[3]->index;
         $arr[3]["end"] = $timezones[0]->start - 1;

         $arr[2]["index"] = $timezones[2]->index;

         $arr[1]["state"] = $timezones[1]->state;
         $arr[1]["start"] = $timezones[1]->start;
         $arr[1]["index"] = $timezones[1]->index;
         $arr[1]["end"] = $timezones[3]->start - 1;

         $arr[0]["state"] = $timezones[0]->state;
         $arr[0]["start"] = $timezones[0]->start;
         $arr[0]["index"] = $timezones[0]->index;
         $arr[0]["end"] = $timezones[1]->start - 1;
         break;

      case 4:
         /* if (isset($arr[1]['audio'])) {
                if (isset($arr[2]['audio'])) {
                    $sound1 = $arr[2]['audio'];
                } else {
                    $sound1 = 0;
                }
                $sound2 = $arr[1]['audio'];
                $arr[1]['audio'] = boolval($sound1);
                $arr[2]['audio'] = boolval($sound2);

                if (isset($arr[1]['va_rec'])) {
                    $anal1 = $arr[1]['va_rec'];
                    $anal2 = 0;
                    if (isset($arr[2]['va_rec'])) {
                        $anal2 = $arr[2]['va_rec'];
                    }
                    $arr[1]['va_rec'] = boolval($anal1);
                    $arr[2]['va_rec'] = boolval($anal2);
                }
            }*/

         $arr[3]["state"] = $timezones[3]->state;
         $arr[3]["start"] = $timezones[3]->start;
         $arr[3]["index"] = $timezones[3]->index;
         $arr[3]["end"] = $timezones[0]->start - 1;

         $arr[1]["state"] = $timezones[1]->state;
         $arr[1]["start"] = $timezones[1]->start;
         $arr[1]["index"] = $timezones[1]->index;
         $arr[1]["end"] = $timezones[2]->start - 1;

         $arr[2]["state"] = $timezones[2]->state;
         $arr[2]["start"] = $timezones[2]->start;
         $arr[2]["index"] = $timezones[2]->index;
         $arr[2]["end"] = $timezones[3]->start - 1;

         $arr[0]["state"] = $timezones[0]->state;
         $arr[0]["start"] = $timezones[0]->start;
         $arr[0]["index"] = $timezones[0]->index;
         $arr[0]["end"] = $timezones[1]->start - 1;
         break;
   }

   return $arr;
}
//компиляция свойств в один обьект по индексам
function toNorm($arr, $atr, $timezones)
{
   for ($i = 0; $i < 4; $i++) {
      foreach ($arr as $obj) {
         if ($obj->index != $i) {
            continue;
         }

         if ($atr == "audio" || $atr == "va_rec") {
            $timezones[$i][$atr] = boolval($obj->value);
            break;
         }

         $timezones[$i][$atr] = $obj->value;
         break;
      }
      if (isset($timezones[$i][$atr]) != false) {
         continue;
      }

      if ($atr == "detskip" || $atr == "motionskip") {
         $timezones[$i][$atr] = -1;
         continue;
      }
      if ($atr == "audio" || $atr == "va_rec") {
         $timezones[$i][$atr] = false;
         continue;
      }
      $timezones[$i][$atr] = 0;
   }
   return $timezones;
}
//возврат пустого массива, если timezones пустой
function addDefaultProperties()
{
   return [
      [
         "index" => 3,
         "state" => 1,
         "start" => 0,
         "end" => 86340,
         "alarmdelay" => 0,
         "audio" => false,
         "detskip" => -1,
         "motionskip" => -1,
         "prevrectime" => 0,
         "va_rec" => false,
      ],
   ];
}
// установка параметров
function setProperties($channel, $name, $timezones, $value)
{
   if (isset($channel->$name)) {
      $arr = toNorm($channel->$name, $name, $timezones);
   } else {
      $arr = toNorm(
         [
            (object) ["index" => 0, "value" => $value],
            (object) ["index" => 1, "value" => $value],
            (object) ["index" => 2, "value" => $value],
            (object) ["index" => 3, "value" => $value],
         ],
         $name,
         $timezones
      );
   }
   return $arr;
}
function setAudioProperties($audio, $param, $name, $timezones, $value)
{
   if (isset($audio->$param)) {
      return toNorm($audio->$param, $name, $timezones);
   }
   return toNorm(
      [
         (object) ["index" => 0, "value" => $value],
         (object) ["index" => 1, "value" => $value],
         (object) ["index" => 2, "value" => $value],
         (object) ["index" => 3, "value" => $value],
      ],
      $name,
      $timezones
   );
}
function checkZeroArray()
{
   $arr = [
      [
         "alarmdelay" => 0,
         "audio" => false,
         "detskip" => -1,
         "motionskip" => -1,
         "prevrectime" => 0,
         "va_rec" => false,
      ],
      [
         "alarmdelay" => 0,
         "audio" => false,
         "detskip" => -1,
         "motionskip" => -1,
         "prevrectime" => 0,
         "va_rec" => false,
      ],
      [
         "alarmdelay" => 0,
         "audio" => false,
         "detskip" => -1,
         "motionskip" => -1,
         "prevrectime" => 0,
         "va_rec" => false,
      ],
      [
         "alarmdelay" => 0,
         "audio" => false,
         "detskip" => -1,
         "motionskip" => -1,
         "prevrectime" => 0,
         "va_rec" => false,
      ],
   ];
   return $arr;
}
// когда отсутствует временая зона

function getZoneValue($array, $defalutValue)
{
   $index = 3;
   foreach ($array as $item) {
      if ($item->index === $index) {
         return isset($item->value) ? $item->value : $defalutValue;
      }
   }
   return $defalutValue;
}

function setZeroProperties($channel, $audio)
{
   $array = [[]];
   //Предзапись, сек
   $array[0]["prevrectime"] = isset($channel->prevrectime) ? getZoneValue($channel->prevrectime, 0) : 0;
   //по движению
   $array[0]["detskip"] = isset($channel->detskip) ? getZoneValue($channel->detskip, -1) : -1;
   //всегда
   $array[0]["motionskip"] = isset($channel->motionskip) ? getZoneValue($channel->motionskip, -1) : -1;
   //Удержание, сек
   $array[0]["alarmdelay"] = isset($channel->alarmdelay) ? getZoneValue($channel->alarmdelay, 0) : 0;
   // Аналитика
   $array[0]["va_rec"] = isset($channel->var_rec) ? boolval(getZoneValue($channel->var_rec, false)) : false;
   // Звук
   $array[0]["audio"] = isset($audio->recorded) ? boolval(getZoneValue($audio->recorded, false)) : false;
   $array[0]["end"] = 86340;
   $array[0]["start"] = 0;
   $array[0]["state"] = 1;
   $array[0]["index"] = 3;
   return $array;
}
function setZeroProperti($channel, $array, $name, $value)
{
   if (isset($channel->$name)) {
      $array[0][$name] = $channel->$name[0]->value;
   } else {
      $array[0][$name] = $value;
   }
   return $array;
}
//присваивание 0 элементу 3, массив начинается с 3-> [3,0,1,2]
function swapByCount($timezones, $count)
{
   if ($count == 1) {
      $timezones[0] = $timezones[3];
   }
   return $timezones;
}
//выдача временной зоны(main)
function getTimeZones($server, $audioArray, $channel)
{
   $audio = getAudioProperties($audioArray, $channel->index);
   if (!isset($server->server->timezone)) {
      if (
         isset($channel->prevrectime) ||
         isset($channel->detskip) ||
         isset($channel->motionskip) ||
         isset($channel->alarmdelay) ||
         isset($channel->var_rec) ||
         isset($audio->recorded)
      ) {
         return setZeroProperties($channel, $audio);
      }
      return addDefaultProperties();
   }
   $timezones = [[], [], [], []];
   //Предзапись, сек
   $timezones = setProperties($channel, "prevrectime", $timezones, 0);
   //по движению
   $timezones = setProperties($channel, "detskip", $timezones, -1);
   //всегда
   $timezones = setProperties($channel, "motionskip", $timezones, -1);
   //Удержание, сек
   $timezones = setProperties($channel, "alarmdelay", $timezones, 0);
   // Аналитика
   $timezones = setProperties($channel, "va_rec", $timezones, false);
   // Звук
   $timezones = setAudioProperties($audio, "recorded", "audio", $timezones, false);
   // проверка на 0 значение
   if ($timezones == [[], [], [], []]) {
      $timezones = checkZeroArray();
   }
   // сортировка временных зон
   $count = countActiveZones($server->server->timezone);
   $timezones = swapByCount($timezones, $count);
   $timezones = addStartAndEndZone($server, $timezones, $count);

   return $timezones;
}
